"""
HB_PipeIt V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_PipeIt
Description-US: Makes a Sweepsetup out of any selected Splines or Edgeselections [SHIFT: CloseCaps, ALT:Closed Splines]


Usage:
Select any Kind of Splineobjects and run the Script. This will create a Sweep Object and also choose the Scaletool so you
can instantly scale the Sweep Profile. This also works for Edgeselections. Holding Shift will close the Caps of the generated sweeps. 
Alt will create closed Splines. That is usefull when you select several Edgeloops for sweeping.

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=46m8s
https://youtu.be/UlY-X5O137M?t=685

ChangeLog:

Jun/11/2015 V1.0 Release Version
Oct/5/2015 V1.0 Nside-Spline Support

Oct/11/2018 V1.1
- Python Rewrite
- Optimizations
- Added Functionality for Shift and Alt modifiers
- New Highres Icon

"""

import c4d
from c4d import gui, utils

def ResetLocalCoordinates(obj):
    m = obj.GetMg()
    m.off = c4d.Vector(0,0,0)
    m.v1 = c4d.Vector(1,0,0)
    m.v2 = c4d.Vector(0,1,0)
    m.v3 = c4d.Vector(0,0,1)
    doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
    obj.SetMl(m)
    
    
def MakePipe(obj):
    pos=obj.GetMg()
    #Sweep
    SweepObj=c4d.BaseObject(c4d.Osweep)
    SweepObj[c4d.CAP_START]=0
    SweepObj[c4d.CAP_END]=0
    if ShiftModifier:
        SweepObj[c4d.CAP_START]=1
        SweepObj[c4d.CAP_END]=1
    name=obj.GetName()
    SweepObj.SetName(name)
    SweepObj.InsertAfter(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW,SweepObj)
    SweepObj.SetMg(pos)
    
    
    doc.AddUndo(c4d.UNDOTYPE_DELETE,obj)
    obj.Remove()
    obj.InsertUnder(SweepObj)
    doc.AddUndo(c4d.UNDOTYPE_NEW,obj)
    ResetLocalCoordinates(obj)
    if AltModifier:
        obj[c4d.SPLINEOBJECT_CLOSED]=True
    #Phongtag
    Phongtag=c4d.BaseTag(5612)
    Phongtag[c4d.PHONGTAG_PHONG_ANGLELIMIT]=True
    SweepObj.InsertTag(Phongtag)

    #Nside
    Nside=c4d.BaseObject(5179)
    Nside[c4d.PRIM_NSIDE_SIDES]=12
    Nside[c4d.PRIM_NSIDE_RADIUS]=5
    Nside.InsertUnder(SweepObj)
    Nside.SetBit(c4d.BIT_ACTIVE)
    obj.DelBit(c4d.BIT_ACTIVE)
    
    
    
    #doc.AddUndo(c4d.UNDOTYPE_CHANGE_SMALL, NewPolyObj)
    #doc.SetSelection(NewPolyObj, c4d.SELECTION_ADD)



    


def pipeit(obj):

    global AltModifier, ShiftModifier
    AltModifier=False
    ShiftModifier=False
    bc = c4d.BaseContainer()    
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        print bc[c4d.BFM_INPUT_QUALIFIER]
        if bc[c4d.BFM_INPUT_QUALIFIER] ==1:
            ShiftModifier=True
        if bc[c4d.BFM_INPUT_QUALIFIER] ==4: 
            AltModifier=True
    
    
    if doc.GetMode()==6 and ID==5100: # is Edgemode active and Polyobject? 
        
        settings = c4d.BaseContainer()                 # Settings Edge to Spline
        utils.SendModelingCommand(command = c4d.MCOMMAND_EDGE_TO_SPLINE,
                                    list = [obj],
                                    mode = c4d.MODELINGCOMMANDMODE_EDGESELECTION,
                                    bc = settings,
                                    doc = doc,
                                    flags = c4d.MODELINGCOMMANDFLAGS_CREATEUNDO)
                                    
        EdgeSpline=obj.GetDown()
        EdgeSpline[c4d.SPLINEOBJECT_INTERPOLATION]=3
        
        
        #OPTIMIZE
        OptCommand= c4d.MCOMMAND_OPTIMIZE
        mode = c4d.MODIFY_ALL
        options = c4d.BaseContainer()
        options[c4d.MDATA_OPTIMIZE_TOLERANCE]=0.001
        options[c4d.MDATA_OPTIMIZE_POINTS] = True
        options[c4d.MDATA_OPTIMIZE_POLYGONS] = True
        utils.SendModelingCommand(command=OptCommand, list=[EdgeSpline], mode=mode, bc=options, doc=doc)
        
        name=obj.GetName()
        EdgeSpline.SetName(name + "_sweep")
        
        MakePipe(EdgeSpline)
    else:
        MakePipe(obj)
        

def main():

    global ID
    doc = c4d.documents.GetActiveDocument()
    doc.StartUndo()

    ObjList = doc.GetOrderedActiveObjects()

    if not ObjList: return

    for obj in ObjList:
        ID=obj.GetType()

        
        if ID == 1019396 or ID == 5187 or ID == 5177 or ID == 5178 or ID == 5176 or ID == 1015653 or ID == 1018655 or ID == 440000054 or ID == 5175 or ID == 5185 or ID == 5182  or ID ==1024610 or ID ==5181 or ID ==5101 or ID ==5100 or ID ==5186 or ID ==5186 or ID== 5179 :
            pipeit(obj)

            
            obj.DelBit(c4d.BIT_ACTIVE)
    

    c4d.CallCommand(200000089) # Scale
    doc.EndUndo()
    


if __name__=='__main__':
    main()
    c4d.EventAdd()
